//=============================================
// CozCopBaton
//=============================================
Class CozCopBaton extends WeaponPistol;

Var PoliceCrimeMon PCM;

function BeginPlay()
{
	local PoliceCrimeMon PCMM;

	foreach AllActors(class'PoliceCrimeMon', PCMM)
	{
		PCM = PCMM;
	}

	Super.BeginPlay();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z) 
{
	local PoliceJailCell Dest;
	local int healthex;
	local int k;
	local float Multuplier;

	if(Owner.IsA('Human'))
	{
		Multuplier = 1.0;
		Multuplier += -2.0 * GetWeaponSkill();
		Healthex=mpHitDamage*Multuplier*2; //mpnoscopemult removed. weaponrifle.
	}
	else
	{
		HealthEx = mpHitDamage;
	}

	if(Other.IsA('Human'))
	{
		for (k=1; k<20; k++)
		{
			if(Human(Other) == PCM.Criminal[k])
			{
				if((Human(Other).HealthHead <= 38) || (Human(Other).HealthTorso <= 30))
				{
					foreach AllActors(Class'PoliceJailCell', Dest) //Cozmo: I might have to make something more specific...
					{
						if(Dest.Prisoner == None)
						{
							BroadcastMessage("|P2"@Human(Other).PlayerReplicationInfo.PlayerName@" has been arrested, with a criminal level of "$PCM.CriminalLevel[k]$".");
							Dest.Accept(Other, self );
							return;
						}
					}
				}
				else
				{
					Super.ProcessTraceHit(Other,Hitlocation,HitNormal,X,Y,Z);
				}
			}
		}
	}
	else
	{
		Super.ProcessTraceHit(Other,Hitlocation,HitNormal,X,Y,Z);
	}

	if((Other.IsA('Pawn')) && Owner.IsA('Human'))
	{
		DeusExPlayer(Owner).ClientMessage("|p2You can only fire at criminals with this weapon!");
	}
}

defaultproperties
{
     bInstantHit=true
     shottime=1.200000
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     reloadTime=0.000000
     AccurateRange=80
     BaseAccuracy=1.000000
     AreaOfEffect=AOE_Cone
     bHasMuzzleFlash=False
     mpHitDamage=5
     mpBaseAccuracy=1.000000
     mpAccurateRange=160
     mpMaxRange=160
     AmmoName=Class'RPGMasterTest.AmmoCredits'
     ReloadCount=0
     FireOffset=(X=-5.000000,Y=8.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.BatonFire'
     SelectSound=Sound'DeusExSounds.Weapons.BatonSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.BatonHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.BatonHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.BatonHitSoft'
     InventoryGroup=259
     bTossedOut=True
     ItemName="Baton"
     PlayerViewOffset=(X=24.000000,Y=-14.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Baton'
     PickupViewMesh=LodMesh'DeusExItems.BatonPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Baton3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconBaton'
     largeIcon=Texture'DeusExUI.Icons.LargeIconBaton'
     largeIconWidth=46
     largeIconHeight=47
     Description="A hefty looking baton, typically used by riot police and national security forces to discourage civilian resistance."
     beltDescription="BATON"
     Mesh=LodMesh'DeusExItems.BatonPickup'
     CollisionRadius=14.000000
     CollisionHeight=1.000000
}
